require "TimedActions/ISBaseTimedAction"

TABAS_ReEquipItems = ISBaseTimedAction:derive("TABAS_ReEquipItems")

local TABAS_Utils = require("TABAS_Utils")

function TABAS_ReEquipItems:grabItem(item, playerInv)
    if instanceof(item, "InventoryItem") and luautils.haveToBeTransfered(self.character, item) then
        ISTimedActionQueue.add(ISInventoryTransferAction:new(self.character, item, item:getContainer(), playerInv, self.grabTime))
        self.grabTime = 0
    end
end

function TABAS_ReEquipItems:isValid()
	return true
end

function TABAS_DrySelf:waitToStart()
    if self.character:isCurrentState(ClimbOverFenceState.instance()) then
        return true
    end
    return self.character:shouldBeTurning()
end

function TABAS_ReEquipItems:perform()
    local equippedItems = self.character:getModData().tabasEquippedItems
    local playerInv = self.character:getInventory()
    local wearTime = self.wearTime

    -- transger items if droped
    if equippedItems.WornClothes then
        equippedItems.WornClothes = ISInventoryPane.getActualItems(equippedItems.WornClothes)
        for _, k in pairs(equippedItems.WornClothes) do
            self:grabItem(k, playerInv)
        end
    end
    if equippedItems.Secondary then
        self:grabItem(equippedItems.Secondary, playerInv)
    end
    if equippedItems.Primary then
        self:grabItem(equippedItems.Primary, playerInv)
    end
    if equippedItems.HotbarAttachedItems then
        for _, l in pairs(equippedItems.HotbarAttachedItems) do
            self:grabItem(l.item, playerInv)
        end
    end
    
    if equippedItems.WornClothes then
        equippedItems.WornClothes = ISInventoryPane.getActualItems(equippedItems.WornClothes)
        for _, item in pairs(equippedItems.WornClothes) do
            ISTimedActionQueue.add(ISWearClothing:new(self.character, item, wearTime))
            wearTime = self.wearTime2
        end
        -- ISInventoryPaneContextMenu.onWearItems(equippedItems.WornClothes, self.player)
    end

    if equippedItems.Secondary and equippedItems.Secondary:getCondition() > 0 then
        if equippedItems.TowHand then
            ISInventoryPaneContextMenu.OnTwoHandsEquip({equippedItems.Secondary}, self.player)
        else
            ISInventoryPaneContextMenu.OnSecondWeapon({equippedItems.Secondary}, self.player)
        end
    end

    if equippedItems.Primary then
        ISInventoryPaneContextMenu.OnPrimaryWeapon({equippedItems.Primary}, self.player)
    end

    -- reattaches hot bar attachments.
    if equippedItems.HotbarAttachedItems then
        ISTimedActionQueue.add(TABAS_ReAttachHotbar:new(self.character, equippedItems.HotbarAttachedItems))
    end

    ISInventoryPage.renderDirty = true
    self.character:getModData().tabasEquippedItems = nil
	-- if self.item:isActivated() ~= self.activated then
		-- self.item:setActivated(self.activated)
	-- end
	ISBaseTimedAction.perform(self)
end

function TABAS_ReEquipItems:new(character, player)
	local o = {}
	setmetatable(o, self)
	self.__index = self
    o.character = character
    o.player = player
    o.grabTime = 50
    o.wearTime = 25
    o.wearTime2 = 25
    local modifyTime = TABAS_Utils.ModOptionsValue("WearingActionTime")
    if modifyTime == 2 then
        o.wearTime = 70
        o.wearTime2 = 1
    elseif modifyTime == 3 then
        o.wearTime = 50
        o.wearTime2 = 50
    end
	o.maxTime = 0
	-- o.activated = activated
	return o
end